#!/user/bin/env python
# _*_ coding:utf-8 _*_
#
#@Version : 1.1
#@Time    : 2018/07/24 10:17
#@Author  : yafei_liu
#@File    : theme_gen.py
#
#Use this file auto generate theme xml, put resource.xml, element.xml, filter.xml, text.xml
#and theme configuration file into current file directory.


import xlrd
import os
import uuid
import re
from xml.dom.minidom import parse
from xml.dom.minidom import Document
import xml.dom.minidom

class Theme_seq:
    def __init__(self):
        self.trans = ''
        self.filter = ''
        self.elem = ''
        self.text = ''
        self.motion = ''
    def isNULL(self):
        return self.trans == '' and self.filter == '' and self.elem == '' and self.text == '' and self.motion == ''
    
class Theme:
    def __init__(self):
        self.theme_seqs = []
        self.name = ''
        
    def isNULL(self):
        return len(self.theme_seqs) == 0

def read_theme_from_multi_cols(sheet):
    themes = []
    for i in range(2, sheet.ncols):
        theme = Theme()
        theme.name = sheet.cell_value(0, i)
        print 'read theme %s' %theme.name
        seq = Theme_seq()
        for j in range(1, sheet.nrows):
            mode = j % 5
            value = sheet.cell_value(j, i)
            regexpobj = re.compile(r'^\d+')
            old_value = value
            value, number = regexpobj.subn('', value)
            value = value.strip()
            if value == '':
                value = old_value
            if value != '' and value != '/':
                if mode == 1:
                    seq.trans = value
                elif mode == 2:
                    seq.filter = value
                elif mode == 3:
                    seq.elem = value
                elif mode == 4:
                    seq.text = value
                elif mode == 0:
                    seq.motion = value
            if not seq.isNULL() and mode == 0:
                theme.theme_seqs.append(seq)
                #print 'trans:', seq.trans, 'filter:',seq.filter, 'elem:',seq.elem, 'text:',seq.text, 'motion:',seq.motion
                seq = Theme_seq()
                #print 'trans:', seq.trans, 'filter:',seq.filter, 'elem:',seq.elem, 'text:',seq.text, 'motion:',seq.motion
        if  not theme.isNULL():
            themes.append(theme)

    return themes
            
def read_theme_config():
    root = '.'
    themes = []
    for name in os.listdir(root):
        full_path = os.path.join(root,name)
        if not os.path.isfile(full_path):
            continue
        if not name.endswith('.xls'):
            continue
            
        data = xlrd.open_workbook(full_path)
        print 'read file %s' %full_path
        sheets = data.sheets()
        for sheet in sheets:
            if sheet.ncols <= 2:
                continue
            print 'read sheet %s' %sheet.name
            tmps = read_theme_from_multi_cols(sheet)
            if len(tmps):
                themes.extend(tmps) 
    return themes
      
def read_guids(filename):
    DOMTree = xml.dom.minidom.parse(filename)
    root_node = DOMTree.documentElement
    items = root_node.getElementsByTagName("category")[0].getElementsByTagName('GUID')
    guid_set = set()
    for item in items:
        guid = item.childNodes[0].data
        guid_set.add(guid)
    return guid_set


g_image_motion = {
    "{00000000-0000-0000-0000-000000000000}",
    "{FF36984D-6449-4548-9ACF-9D6D545A30A3}",
    "{89574E14-1152-486A-B788-21FD6960C8B0}",
    "{5FB410F2-6754-4D1E-94A4-5E6B2D21C6F9}",
    "{F2415AEC-0F1B-49D1-ABB6-7817844E3208}",
    "{4862CACB-8974-4895-8EB1-163602F54D66}",
    "{F9901C30-A174-4C2C-A29E-215AF6B1F583}",
    "{A4BC7806-455C-432B-B2D0-919B3F103467}"
}

def read_resource_config():
    filter_name_to_guid = {}
    elem_name_to_guid = {}
    text_name_to_guid = {}
    trans_name_to_guid = {}
    motion_name_to_guid = {}
    
    elem_set = read_guids('element.xml')
    filter_set = read_guids('filter.xml')
    text_set = read_guids('text.xml')
    
    print "reading resource from resource.xml" 
    DOMTree = xml.dom.minidom.parse("resource.xml")
    resource = DOMTree.documentElement
    
    items = []
    items = resource.getElementsByTagName("Filter")[0].getElementsByTagName('Item')
    for item in items:
        guid = item.getElementsByTagName("GUID")[0].childNodes[0].data.decode('string_escape')
        name = item.getElementsByTagName("Name")[0].childNodes[0].data.decode('string_escape')
        if guid in filter_set or guid.lower() in filter_set:
            if filter_name_to_guid.has_key(name):
                print name
                assert(False)
            filter_name_to_guid[name] = guid
        elif guid in elem_set or guid.lower() in elem_set:
            if elem_name_to_guid.has_key(name):
                print name
                assert(False)
            elem_name_to_guid[name] = guid
        elif guid in text_set or guid.lower() in text_set:
            if text_name_to_guid.has_key(name):
                print name
                assert(False)
            text_name_to_guid[name] = guid
        else:
            print name
            print guid
            print text_set
            assert(False)
            
        
    items = resource.getElementsByTagName("Transition")[0].getElementsByTagName('Item')
    for item in items:
        guid = item.getElementsByTagName("GUID")[0].childNodes[0].data
        name = item.getElementsByTagName("Name")[0].childNodes[0].data
        if trans_name_to_guid.has_key(name):
            assert(False)
        trans_name_to_guid[name] = guid
    
    items = resource.getElementsByTagName("Motion")[0].getElementsByTagName('Item')
    for item in items:
        guid = item.getElementsByTagName("GUID")[0].childNodes[0].data
        name = item.getElementsByTagName("Name")[0].childNodes[0].data
        
        if guid not in g_image_motion:
            continue

        if motion_name_to_guid.has_key(name):
            print name
            assert(False)
        motion_name_to_guid[name] = guid

    return [filter_name_to_guid, elem_name_to_guid, text_name_to_guid, trans_name_to_guid, motion_name_to_guid]
    
def collect_name(theme_seqs):
    trans = []
    filter = []
    elem = []
    text = []
    motion = []
    #print '------------'
    for seq in theme_seqs:
        trans.append(seq.trans)
        filter.append(seq.filter)
        elem.append(seq.elem)
        text.append(seq.text)
        motion.append(seq.motion)
        #print 'trans:', seq.trans, 'filter:',seq.filter, 'elem:',seq.elem, 'text:',seq.text, 'motion:',seq.motion
    
    return (trans, filter, elem, text, motion)
    
def write_sub_node(name_to_guid, strs, doc, tag_name):
    zero_guid = '{00000000-0000-0000-0000-000000000000}'
    parent_node = doc.createElement(tag_name)
    #print '/*****************************************/'
    #print tag_name
    for text in strs:
        #print text
        if not name_to_guid.has_key(text) and text != '':
            print strs
            print text
            assert(False)
        str_guid = ''
        if text == '':
            str_guid = zero_guid
        else:
            str_guid = name_to_guid[text]

        guid_node = doc.createElement('GUID')
        parent_node.appendChild(guid_node)
        sub_uuid = doc.createTextNode(str_guid)
        guid_node.appendChild(sub_uuid)
    #print '/*****************************************/'
    return parent_node

def generate_theme():
    [filter_name_to_guid, elem_name_to_guid, text_name_to_guid, trans_name_to_guid, motion_name_to_guid] = read_resource_config()
    themes = read_theme_config()
    total = open('theme.txt','w')
    
    for theme in themes:
        doc = Document()
        
        theme_node = doc.createElement('Theme')
        doc.appendChild(theme_node)
        
        guid_node = doc.createElement('GUID')
        theme_node.appendChild(guid_node)
        str_theme_uuid = str(uuid.uuid1())
        str_theme_uuid = '{' + str_theme_uuid + '}'
        theme_uuid = doc.createTextNode(str_theme_uuid)
        guid_node.appendChild(theme_uuid)
        
        name_node = doc.createElement('Name')
        theme_node.appendChild(name_node)
        name = doc.createTextNode(theme.name)
        name_node.appendChild(name)
        
        (trans, filter, elem, text, motion) = collect_name(theme.theme_seqs)
        print 'generate %s' %theme.name
        theme_node.appendChild(write_sub_node(text_name_to_guid, text, doc, 'Text'))
        theme_node.appendChild(write_sub_node(filter_name_to_guid, filter, doc, 'Filter'))
        theme_node.appendChild(write_sub_node(elem_name_to_guid, elem, doc, 'Element'))
        theme_node.appendChild(write_sub_node(trans_name_to_guid, trans, doc, 'Transition'))
        theme_node.appendChild(write_sub_node(motion_name_to_guid, motion, doc, 'ImageMotion'))
        
        path = './%s' %theme.name
        if not os.path.exists(path):
            os.mkdir(path)
        full_path = '%s/%s.xml'%(path, theme.name)
        with open(full_path,'w') as f:
            doc.writexml(f,indent = '\t', addindent = '\t', newl = '\n', encoding='utf-8')

        #print '<Theme>'
        #print '\t<GUID>%s</GUID>'%str_theme_uuid
        #print '\t<Name>%s</Name>'%theme.name
        #print '\t<UrlThumb></UrlThumb>'
        #print '\t<UrlPreview></UrlPreview>'
        #print '\t<UrlCnf>%s.xml</UrlCnf>'%theme.name
        #print '</Theme>'

        total.writelines('<Theme>\n')
        total.writelines('\t<GUID>%s</GUID>\n'%str_theme_uuid)
        total.writelines('\t<Name>%s</Name>\n'%theme.name)
        total.writelines('\t<UrlThumb></UrlThumb>\n')
        total.writelines('\t<UrlPreview></UrlPreview>\n')
        total.writelines('\t<UrlCnf>%s.xml</UrlCnf>\n'%theme.name)
        total.writelines('</Theme>\n')
    
    total.close()
    
if __name__ == '__main__':
    generate_theme()